#include <stdio.h>
#include "coco.h"

#define PHYS_TRACK(ls)	((ls)/COCO_SECTORS)
#define PHYS_SECTOR(ls)	((ls)%COCO_SECTORS)

/************************************************************************
 * NAME:	coco_putlsect() & coco_getlsect()
 *
 * DESCR:	write/read a logical sector to floppy.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
coco_putlsect(struct cocofs *cocofs, int lsect, char buf[])
{
    return(coco_putpsect(cocofs,PHYS_TRACK(lsect),PHYS_SECTOR(lsect),buf));
}

int
coco_getlsect(struct cocofs *cocofs, int lsect, char buf[])
{
    return(coco_getpsect(cocofs,PHYS_TRACK(lsect),PHYS_SECTOR(lsect),buf));
}

/************************************************************************
 * NAME:	coco_putpsect()
 *
 * DESCR:	Write physical sector to floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:
 ************************************************************************/
int
coco_putpsect(struct cocofs *cocofs, int track, int sect, char buf[])
{
    return((*cocofs->pwritesec)(cocofs->device,0,track,sect+cocofs->startsec,buf));
}

/************************************************************************
 * NAME:	coco_getpsect()
 *
 * DESCR:	Read physical sector from floppy disk file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if OK, FALSE otherwise.
 *
 * NOTES:
 ************************************************************************/
int
coco_getpsect(struct cocofs *cocofs, int track, int sect, char buf[])
{
    return((cocofs->preadsec)(cocofs->device,0,track,sect+cocofs->startsec,buf));
}

